<?php
require_once("Rest.php");
require_once("ProjectList.php");
		
class ProjectListRestHandler extends Rest {

	function getAllDomains() {	

		$projectList = new ProjectList();
		$rawData = $projectList->getAllDomains();
		
		#echo $rawData;

		if(empty($rawData)) {
			$statusCode = 404;
			echo '404';
			$rawData = array('error' => 'No Domains found!');		
		} else {
			$statusCode = 200;
		}
		
		$requestContentType = 'application/json';//$_POST['HTTP_ACCEPT'];
		$this ->setHttpHeaders($requestContentType, $statusCode);
		
		$result["domain_result"] = $rawData;
		
		if(strpos($requestContentType,'application/json') !== false){
			$response = $this->encodeJson($result);
			echo $response;
		}
	}
	
	
	function getAllProjects($domainShtName) {	

		$projectList = new ProjectList();
		$rawData = $projectList->getAllProjects($domainShtName);
		
		#echo $rawData;

		if(empty($rawData)) {
			$statusCode = 404;
			echo '404';
			$rawData = array('error' => 'No Projects found!');		
		} else {
			$statusCode = 200;
		}
		
		$requestContentType = 'application/json';//$_POST['HTTP_ACCEPT'];
		$this ->setHttpHeaders($requestContentType, $statusCode);
		
		$result["projectList"] = $rawData;
		
		if(strpos($requestContentType,'application/json') !== false){
			$response = $this->encodeJson($result);
			echo "--------------------";
			echo $response;
		}
	}
	
	public function encodeJson($responseData) {
		$jsonResponse = json_encode($responseData);
		print $jsonResponse;
		
		return $jsonResponse;		
	}
}
?>